//+------------------------------------------------------------------+
//|                                            ONNX collect data.mq5 |
//|                                     Copyright 2023, Omega Joctan |
//|                        https://www.mql5.com/en/users/omegajoctan |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, Omega Joctan"
#property link      "http://fxalgebra.com"
#property version   "1.00"

#include <preprocessing.mqh> //This library contains the normalization techniques for machine learning
#include <MatrixExtend.mqh>
#include <Dimensionality Reduction\PCA.mqh>

CPCA *pca;
StandardizationScaler scaler; //We want to use z-normalization/standardization technique for this project

input int data_size = 10000; 
input bool use_pca = true;

MqlRates rates[];
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//--- vector.CopyRates is lacking we are going to copy rates in normal way

   ArraySetAsSeries(rates, true);    
   if (CopyRates(Symbol(), PERIOD_D1, 1, data_size, rates)<-1)
     {
       printf("Failed to collect data Err=%d",GetLastError());
       return;
     }
   

   matrix OHLC(data_size, 4);
   for (int i=0; i<data_size; i++) //Get OHLC values and save them to a matrix
     {
       OHLC[i][0] = rates[i].open;
       OHLC[i][1] = rates[i].high;
       OHLC[i][2] = rates[i].low;
       
        if (rates[i].close>rates[i].open)
          OHLC[i][3] = 1; //Buy signal
        else if (rates[i].close<rates[i].open)
          OHLC[i][3] = 0; //sell signal
     }

//---
  
   matrix x;
   vector y;
   MatrixExtend::XandYSplitMatrices(OHLC, x, y);  //WE split the data into x and y | The last column in the matrix will be assigned to the y vector 

//--- Reduce data dimension
     
     if (use_pca)
      { 
         pca = new CPCA(2); //reduce the data to have two columns
         x = pca.fit_transform(x);
         if (!pca.save(Symbol()+"-PCA"))
           return;
      }
      
//--- Standardize the data  
     
   x = scaler.fit_transform(x);   
   if (!scaler.save(Symbol()+(use_pca?"-PCA":"")+"-SCALER"))
      return;
   
   OHLC = MatrixExtend::concatenate(x, y); //We apped the y column to the scaled x matrix, this is the opposite of XandYsplitMatrices function
   if (!MatrixExtend::WriteCsv(Symbol()+(use_pca?"-OHLSignalPCA.csv":"-OHLSignal.csv"),OHLC,use_pca?NULL:"open,high,low,signal",false,8))       
    {
     DebugBreak();
     return;
    }
   
   if (CheckPointer(pca)!=POINTER_INVALID)
      delete pca;
  }
//+------------------------------------------------------------------+
